<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Paysera\Delivery\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Delivery\Entity\MerchantCart;
use Paysera\Delivery\Entity\MerchantCartInterface;
use Cart;
use Paysera\Delivery\Entity\MerchantOrder;
use Paysera\Delivery\Entity\MerchantOrderInterface;

class MerchantCartModel implements MerchantCartModelInterface
{
    public function find(int $cartId): MerchantCartInterface
    {
        return new MerchantCart(new Cart($cartId));
    }

    /**
     * @param MerchantCartInterface<MerchantCart> $cart
     * @param MerchantOrderInterface<MerchantOrder> $order
     * @return MerchantCartInterface
     */
    public function refreshItems(MerchantCartInterface $cart, MerchantOrderInterface $order): MerchantCartInterface
    {
        foreach ($cart->getCart()->getProducts() as $product) {
            $cart->getCart()->deleteProduct((int) $product['id_product'], (int) $product['id_product_attribute']);
        }

        foreach ($order->getOrder()->getProducts() as $product) {
            $cart->getCart()->updateQty(
                $product['product_quantity'],
                (int) $product['product_id'],
                null,
                false,
                'up',
                0,
                null,
                true,
                true
            );
        }

        return $cart;
    }
}
