<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\HookHandler;

use Paysera\Delivery\OrderHookHandlerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class OrderHookHandler implements OrderHookHandlerInterface
{
    /**
     * @var OrderHandlerFactory
     */
    private $orderHandlerFactory;
    /**
     * @var ContainerInterface
     */
    private $container;

    public function __construct(OrderHandlerFactory $orderHandlerFactory, ContainerInterface $container)
    {
        $this->orderHandlerFactory = $orderHandlerFactory;
        $this->container = $container;
    }

    public function handleHookOrderConfirmation(array $parameters): void
    {
        $this->orderHandlerFactory
            ->getOrderConfirmationHandler()
            ->handle(
                $this->getModuleContextParameters($parameters)
            )
        ;
    }

    public function handleHookActionOrderStatusPostUpdate(array $parameters): void
    {
        $this->orderHandlerFactory
            ->getActionOrderStatusPostUpdateHandler()
            ->handle(
                $this->getModuleContextParameters($parameters)
            )
        ;
    }

    public function handleHookPayseraPaymentConfirmed(array $parameters): void
    {
        $this->orderHandlerFactory
            ->getPayseraPaymentConfirmedHandler()
            ->handle(
                $this->getModuleContextParameters($parameters)
            )
        ;
    }

    private function getModuleContextParameters(array $parameters): HookHandlerParameters
    {
        return new HookHandlerParameters(
            $this->container->get('paysera.payseradelivery.module'),
            $parameters
        );
    }
}
