<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Delivery\Entity\MerchantOrder;
use Paysera\Delivery\Factory\MerchantOrderAddressFactory;
use Paysera\Delivery\HookHandler\OrderHandler\DeliveryOrderUpdatedHandler;
use Paysera\Delivery\Model\MerchantCarrierModel;
use Paysera\Delivery\Model\MerchantCartModel;
use Paysera\Delivery\Model\MerchantCountryModel;
use Paysera\Delivery\Model\MerchantOrderAddressModel;
use Paysera\Delivery\Model\MerchantOrderModel;
use Paysera\Delivery\Model\PayseraShippingGatewayModel;
use Paysera\Delivery\PayseraDeliveryCarriers;
use Paysera\Delivery\PayseraDeliveryConfiguration;
use Paysera\Delivery\Service\DeliveryOrderMessageGenerator;

class PayseraDeliveryCallbackModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
        if (!$this->module->active) {
            exit;
        }

        $deliveryApiClient = $this->module
            ->getServiceContainer()
            ->getService('paysera.payseradelivery.service.delivery_api_client')
        ;

        $orderId = Tools::getValue('id_order');

        try {
            $order = new Order((int)$orderId);

            if (!Validate::isLoadedObject($order)) {
                throw new Exception('Order not found');
            }

            $shipmentRequestModel = $this->module
                ->getServiceContainer()
                ->getService('paysera.payseradelivery.model.shipment_request_model')
            ;

            $configuration = new PayseraDeliveryConfiguration();
            $carriers = new PayseraDeliveryCarriers($this->module, $configuration);
            $deliveryOrderMessageGenerator = new DeliveryOrderMessageGenerator(
                (int) $this->context->shop->id,
                (int) $this->context->language->id,
                (int) $order->id,
                (int) $order->id_customer,
                [$this->module, 'l']
            );

            $handler = new DeliveryOrderUpdatedHandler(
                $configuration,
                $deliveryApiClient,
                $deliveryOrderMessageGenerator,
                $shipmentRequestModel,
                $carriers,
                new MerchantOrderModel(),
                new MerchantOrderAddressModel(),
                new MerchantOrderAddressFactory(),
                new MerchantCartModel(),
                new MerchantCountryModel(),
                new PayseraShippingGatewayModel($carriers),
                new MerchantCarrierModel()
            );

            $handler->handle(['order' => new MerchantOrder($order)]);

            exit('OK');
        } catch (Exception $e) {
            exit($e->getMessage());
        }
    }
}
