<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminPayseraDeliveryPaymentController extends ModuleAdminController
{
    public const PAYSERA_PAYMENT_MODULE_NAME = 'paysera';
    /**
     * @var string
     */
    public $php_self;

    public function __construct()
    {
        parent::__construct();
        $this->bootstrap = true;

        $this->php_self = 'AdminPayseraDelivery';
    }

    public function initContent(): void
    {
        parent::initContent();

        if ($this->isPaymentPluginEnabled() === true) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules')
                . '&configure=' . self::PAYSERA_PAYMENT_MODULE_NAME)
            ;
        }
    }

    public function renderList(): ?string
    {
        parent::renderList();

        $this->context->smarty->assign([
            'paymentPluginUrl' => $this->l('link_payment_plugin'),
            'isEnabled' => $this->isPaymentPluginEnabled(),
            'enableLink' => $this->context->link->getAdminLink('AdminModules')
                . '&enable=1&module_name=' . self::PAYSERA_PAYMENT_MODULE_NAME
                . '&configure=' . self::PAYSERA_PAYMENT_MODULE_NAME,
            'enableLinkLabel' => $this->l('enable_plugin'),
            'uploadLink' => $this->context->link->getAdminLink('AdminModules'),
            'uploadLinkLabel' => $this->l('upload_plugin'),
            'isUploaded' => $this->isPaymentPluginUploaded(),
        ]);

        return $this->module->display(
            _PS_MODULE_DIR_ . '/' . $this->module->name,
            'views/templates/admin/pages/payments.tpl'
        );
    }

    private function isPaymentPluginUploaded(): bool
    {
        return is_dir(_PS_MODULE_DIR_ . '/' . self::PAYSERA_PAYMENT_MODULE_NAME);
    }

    private function isPaymentPluginEnabled(): bool
    {
        return Module::isEnabled(self::PAYSERA_PAYMENT_MODULE_NAME);
    }
}
