{**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 *}
<script type='text/javascript' src="{$backOfficeJsUrl|escape:'htmlall':'UTF-8'}"></script>
<link href="{$backOfficeCssUrl|escape:'htmlall':'UTF-8'}" rel="stylesheet" type="text/css">

{if $message}
    {if $message.success}
        {assign var="alert" value="alert-success"}
    {else}
        {assign var="alert" value="alert-danger"}
    {/if}
    <div class="bootstrap">
        <div class="module_confirmation conf confirm alert {$alert|escape:'htmlall':'UTF-8'}">
            <button type="button" class="close" data-dismiss="alert">×</button>
            {$message.text|escape:'htmlall':'UTF-8'}
        </div>
    </div>
{/if}

<div id="formSettingsPanel" class="panel">
    <div class="panel-heading">
        <i class="icon-cogs"></i>
        {$settingsTitle|escape:'htmlall':'UTF-8'}
    </div>
    <div class="row">
        <div class="col-lg-12">
            <img class="paysera-configuration-logo" src="{$imageDirectory}paysera.svg" alt="Paysera" title="Paysera"/>
        </div>
    </div>
    <div class="paysera-delivery-tabs">
        {if $configuration_tabs}
            <nav>
                {foreach $configuration_tabs as $tab}
                    <a class="tab-title
                    {if isset($selectedTab) && $tab.id==$selectedTab}nav-tab-active{/if}"
                       href="#"
                       id="{$tab.id|escape:'htmlall':'UTF-8'}"
                       data-target="#paysera-delivery-tabs-{$tab.id|escape:'htmlall':'UTF-8'}">
                        {$tab.title|escape:'htmlall':'UTF-8'}
                    </a>
                {/foreach}
            </nav>
            <div class="content">
                {foreach $configuration_tabs as $tab}
                    <div class="tab-content" id="paysera-delivery-tabs-{$tab.id|escape:'htmlall':'UTF-8'}">
                        {if $tab.id == 'carrier_settings'}
                            {foreach from=$tab.content item=data key=gatewayCode}
                                <div class="row paysera-carrier-row">
                                    <div class="col-lg-3">
                                        <div clas="row">
                                            <div class="col-lg-12">
                                                {$data.image}
                                            </div>
                                            <div class="col-lg-12">
                                                <span>{$data.description}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 paddingtop8">
                                        {if $data.enabled == 1}
                                            <form action="{$tab.action_link}" method="post" enctype="multipart/form-data">
                                                <input type="hidden" name="carriers_post_data[gateway_code]" value="{$gatewayCode}">
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <select name="carriers_post_data[shipping_method]">
                                                            {foreach from=$data.shipping_methods item=shipment_method key=shipment_index}
                                                                <option value="{$shipment_index}">
                                                                    {if $shipment_method.shipment_code == 'courier2courier'}
                                                                        {l s='courier2courier' mod='payseradelivery'}
                                                                    {/if}
                                                                    {if $shipment_method.shipment_code == 'courier2parcel-machine'}
                                                                        {l s='courier2parcel-machine ' mod='payseradelivery'}
                                                                    {/if}
                                                                    {if $shipment_method.shipment_code == 'parcel-machine2courier'}
                                                                        {l s='parcel-machine2courier' mod='payseradelivery'}
                                                                    {/if}
                                                                    {if $shipment_method.shipment_code == 'parcel-machine2parcel-machine'}
                                                                        {l s='parcel-machine2parcel-machine' mod='payseradelivery'}
                                                                    {/if}
                                                                </option>
                                                            {/foreach}
                                                        </select>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <button type="submit" value="1" name="btnCarrierSubmit" class="btn paysera-btn">
                                                            {l s='text_add_new' mod='payseradelivery'}
                                                        </button>
                                                    </div>
                                                    <div class="col-lg-4">
                                                            {$data.settings_link}
                                                    </div>
                                                </div>
                                            </form>
                                        {/if}
                                    </div>
                                    <div class="col-lg-3 paddingtop8">
                                        <form action="{$tab.action_link}" method="post" enctype="multipart/form-data">
                                            <input type="hidden" name="carriers_post_data[enabled]" value="{$data.enabled}">
                                            <input type="hidden" name="carriers_post_data[gateway_code]" value="{$gatewayCode}">
                                            <button type="submit" value="1" name="btnCarrierSubmit" class="btn paysera-btn">
                                                {if $data.enabled == 1}
                                                    {l s='text_disable' mod='payseradelivery'}
                                                {else}
                                                    {l s='text_enable' mod='payseradelivery'}
                                                {/if}
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            {/foreach}
                        {else}
                            {html_entity_decode($tab.content|escape:'htmlall':'UTF-8')}
                        {/if}
                    </div>
                {/foreach}
            </div>
        {/if}
    </div>
</div>
