<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Delivery\PayseraDeliveryConfiguration;

function upgradeModule150($module)
{
    $carrierList = Configuration::get(PayseraDeliveryConfiguration::DELIVERY_CARRIER_LIST);
    $result = $carrierList !== false ? json_decode($carrierList, true) : [];
    $parcelLockerDisabledGateways = ['tnt', 'itella'];

    foreach ($result as $carrier) {
        if (
            in_array($carrier['code'], $parcelLockerDisabledGateways, true)
            && strpos($carrier['type'], PayseraDeliveryConfiguration::TYPE_PARCEL_MACHINE) !== false
        ) {
            (new Carrier((int) $carrier['carrier_id']))->delete();
        }
    }

    return true;
}
