<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\Provider;

use Exception;
use Paysera\Delivery\PayseraDeliveryConfiguration;
use Paysera\Delivery\Service\Logger;
use Paysera\DeliveryApi\MerchantClient\ClientFactory;
use Paysera\DeliveryApi\MerchantClient\MerchantClient;

class MerchantClientProvider
{
    /**
     * @var MerchantClientFactoryProvider
     */
    private $merchantClientFactoryProvider;
    /**
     * @var Logger
     */
    private $logger;

    /**
     * MerchantClientProvider constructor.
     *
     * @param MerchantClientFactoryProvider $merchantClientFactoryProvider
     * @param Logger $logger
     */
    public function __construct(MerchantClientFactoryProvider $merchantClientFactoryProvider, Logger $logger)
    {
        $this->merchantClientFactoryProvider = $merchantClientFactoryProvider;
        $this->logger = $logger;
    }

    /**
     * Get the MerchantClient instance.
     *
     * @return MerchantClient|null
     */
    public function getMerchantClient(): ?MerchantClient
    {
        $merchantClient = null;
        $clientFactory = $this->merchantClientFactoryProvider->getMerchantClientFactory();

        try {
            $merchantClient = $clientFactory->getMerchantClient();
        } catch (Exception $exception) {
            $this->logger->error('Cannot create merchant client. Check Project ID and Password', $exception);
        }

        return $merchantClient;
    }
}
