<?php

namespace Paysera\Delivery\Provider;

use Paysera\Delivery\PayseraDeliveryConfiguration;
use Paysera\DeliveryApi\MerchantClient\ClientFactory;

class MerchantClientFactoryProvider
{
    private const BASE_URL = 'https://delivery-api.paysera.com/rest/v1/';

    /**
     * @var PayseraDeliveryConfiguration
     */
    private $configuration;

    /**
     * MerchantClientFactoryProvider constructor.
     *
     * @param PayseraDeliveryConfiguration $configuration
     */
    public function __construct(PayseraDeliveryConfiguration $configuration)
    {
        $this->configuration = $configuration;
    }

    public function getMerchantClientFactory(): ClientFactory
    {
        return new ClientFactory([
            'base_url' => self::BASE_URL,
            'mac' => [
                'mac_id' => $this->configuration->getProjectId(),
                'mac_secret' => $this->configuration->getProjectPassword(),
            ],
        ]);
    }
}
