<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\HookHandler;

use Paysera\Delivery\HookHandler\OrderHandler\ActionOrderStatusPostUpdateHandler;
use Paysera\Delivery\HookHandler\OrderHandler\PayseraPaymentConfirmedHandler;
use Paysera\Delivery\Manager\ShipmentRequestManager;
use Paysera\Delivery\PayseraDeliveryCarriers;
use Paysera\Delivery\Service\DeliveryApiClient;
use Paysera\Delivery\Service\Logger;
use Paysera\Delivery\PayseraDeliveryConfiguration;
use Paysera\Delivery\Model\ShipmentRequestModel;
use Paysera\Delivery\HookHandler\OrderHandler\OrderConfirmationHandler;

class OrderHandlerFactory
{
    /**
     * @var Logger
     */
    private $logger;
    /**
     * @var PayseraDeliveryConfiguration
     */
    private $configuration;
    /**
     * @var DeliveryApiClient
     */
    private $deliveryApiClient;
    /**
     * @var ShipmentRequestModel
     */
    private $shipmentRequestModel;
    /**
     * @var ShipmentRequestManager
     */
    private $shipmentRequestManager;
    /**
     * @var PayseraDeliveryCarriers
     */
    private $payseraDeliveryCarriers;

    public function __construct(
        Logger $logger,
        PayseraDeliveryConfiguration $configuration,
        DeliveryApiClient $deliveryApiClient,
        ShipmentRequestModel $shipmentRequestModel,
        ShipmentRequestManager $shipmentRequestManager,
        PayseraDeliveryCarriers $payseraDeliveryCarriers
    ) {
        $this->logger = $logger;
        $this->configuration = $configuration;
        $this->deliveryApiClient = $deliveryApiClient;
        $this->shipmentRequestModel = $shipmentRequestModel;
        $this->shipmentRequestManager = $shipmentRequestManager;
        $this->payseraDeliveryCarriers = $payseraDeliveryCarriers;

    }

    public function getOrderConfirmationHandler(): OrderHandlerInterface
    {
        return new OrderConfirmationHandler(
            $this->logger,
            $this->configuration,
            $this->deliveryApiClient,
            $this->shipmentRequestModel,
            $this->payseraDeliveryCarriers
        );
    }

    public function getActionOrderStatusPostUpdateHandler(): OrderHandlerInterface
    {
        return new ActionOrderStatusPostUpdateHandler(
            $this->logger,
            $this->configuration,
            $this->deliveryApiClient,
            $this->shipmentRequestModel,
            $this->payseraDeliveryCarriers
        );
    }

    public function getPayseraPaymentConfirmedHandler(): OrderHandlerInterface
    {
        return new PayseraPaymentConfirmedHandler(
            $this->logger,
            $this->deliveryApiClient,
            $this->shipmentRequestModel,
            $this->shipmentRequestManager
        );
    }
}
