<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\HookHandler\OrderHandler;

use Paysera\Delivery\HookHandler\HookHandlerParameters;
use Paysera\Delivery\HookHandler\OrderHandlerInterface;
use Paysera\Delivery\Model\ShipmentRequestModel;
use Paysera\Delivery\PayseraDeliveryConfiguration;
use Paysera\Delivery\Service\DeliveryApiClient;
use Paysera\Delivery\Service\Logger;
use Order;
use Validate;
use Paysera\Delivery\PayseraDeliveryCarriers;

class ActionOrderStatusPostUpdateHandler extends AbstractOrderCreateHandler implements OrderHandlerInterface
{
    /**
     * @var ShipmentRequestModel $shipmentRequestModel
     */
    private  $shipmentRequestModel;

    public function __construct(
        Logger $logger,
        PayseraDeliveryConfiguration $configuration,
        DeliveryApiClient $deliveryApiClient,
        ShipmentRequestModel $shipmentRequestModel,
        PayseraDeliveryCarriers $payseraDeliveryCarriers
    ) {
        parent::__construct($logger, $configuration, $deliveryApiClient, $payseraDeliveryCarriers);
        $this->shipmentRequestModel = $shipmentRequestModel;
    }

    public function handle(HookHandlerParameters $hookHandlerParameters): void
    {
        $params = $hookHandlerParameters->getParams();
        $module = $hookHandlerParameters->getModule();

        if ($this->configuration->isTestModeEnabled()) {
            return;
        }

        $order = new Order($params['id_order']);

        if (!Validate::isLoadedObject($order) || $order->id === null) {
            $this->logger->error(
                sprintf(
                    'Order not found for order ID: %d',
                    $params['id_order']
                )
            );

            return;
        }

        $shipmentRequest = $this->shipmentRequestModel->find($order->id);

        if ($shipmentRequest === null) {
            $this->logger->info(
                sprintf(
                    'Shipment request not found for order ID: %d',
                    $order->id
                )
            );

            return;
        }

        if ($shipmentRequest->getDeliveryOrderApiId() !== null) {
            $this->logger->info(
                sprintf(
                    'Delivery order already created for order ID: %d',
                    $order->id
                )
            );

            return;
        }

        $this->handleDeliveryOrderCreation(
            $module,
            $order,
            $shipmentRequest
        );
    }
}
