<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\Helper;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Paysera\Delivery\Normalizer\TabNormalizer;

class TabHelper
{
    private const PAYSERA_PAYMENT_MODULE_NAME = 'paysera';
    private const PARENT_TAB_NAME = 'AdminPayseraDeliveryParent';
    /**
     * @var array<string, array<string, string|array>>
     */
    private $tabs;

    public function __construct()
    {
        $this->tabs = [
            [
                'name' => 'Paysera',
                'class_name' => self::PARENT_TAB_NAME,
                'parent_id' => 'CONFIGURE',
                'module' => 'payseradelivery',
                'languages' => [],
            ],
            [
                'name' => 'About',
                'class_name' => 'AdminPayseraDeliveryAbout',
                'parent_id' => self::PARENT_TAB_NAME,
                'module' => 'payseradelivery',
                'languages' => [
                    'lt' => 'Apie',
                    'ru' => 'О нас',
                    'en' => 'About',
                ],
            ],
            [
                'name' => 'Delivery',
                'class_name' => 'AdminPayseraDelivery',
                'parent_id' => self::PARENT_TAB_NAME,
                'module' => 'payseradelivery',
                'languages' => [
                    'lt' => 'Pristatymas',
                    'ru' => 'Доставка',
                    'en' => 'Delivery',
                ],
            ],
            [
                'name' => 'Payment',
                'class_name' => 'AdminPayseraDeliveryPayment',
                'parent_id' => self::PARENT_TAB_NAME,
                'module' => 'payseradelivery',
                'languages' => [
                    'lt' => 'Mokėjimai',
                    'ru' => 'Оплата',
                    'en' => 'Payment',
                ],
            ],
        ];
    }

    public function installTabs(): void
    {
        foreach ($this->tabs as $tabSettings) {
            $existingTabId = \Tab::getIdFromClassName($tabSettings['class_name']);

            if ($existingTabId !== false) {
                continue;
            }

            $tab = (new TabNormalizer())->mapToEntity($tabSettings);

            $tab->add();
        }
    }

    public function uninstallTabs(): void
    {
        foreach ($this->tabs as $tabSettings) {
            $tabId = \Tab::getIdFromClassName($tabSettings['class_name']);

            if ($tabId === false) {
                continue;
            }

            $tab = new \Tab($tabId);

            if (
                $tabSettings['class_name'] === self::PARENT_TAB_NAME
                && \Module::isEnabled(self::PAYSERA_PAYMENT_MODULE_NAME)
            ) {
                $tab->module = self::PAYSERA_PAYMENT_MODULE_NAME;

                $tab->save();

                continue;
            }

            $tab->delete();
        }
    }
}
