<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */
declare(strict_types=1);

namespace Paysera\Delivery\Entity;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ShipmentRequest
{
    public const STATUS_NEW = 'new';
    public const STATUS_PAID = 'paid';
    public const STATUS_COMPLETED = 'completed';

    /**
     * @var int|null
     */
    private $id = null;

    /**
     * @var int
     */
    private $orderId;

    /**
     * @var string
     */
    private $carrierCode;

    /**
     * @var string
     */
    private $carrierType;

    /**
     * @var string
     */
    private $status;

    /**
     * @var ?ShipmentRequestGateway
     */
    private $shippingRequestGateway;

    /**
     * @var string
     */
    private $deliveryOrderApiId;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        if ($this->id === null) {
            $this->id = $id;
        }

        return $this;
    }

    public function getOrderId(): int
    {
        return $this->orderId;
    }

    public function setOrderId(int $orderId): self
    {
        $this->orderId = $orderId;

        return $this;
    }

    public function getCarrierCode(): string
    {
        return $this->carrierCode;
    }

    public function setCarrierCode(string $carrierCode): self
    {
        $this->carrierCode = $carrierCode;

        return $this;
    }

    public function getCarrierType(): string
    {
        return $this->carrierType;
    }

    public function setCarrierType(string $carrierType): self
    {
        $this->carrierType = $carrierType;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getShippingRequestGateway(): ?ShipmentRequestGateway
    {
        return $this->shippingRequestGateway;
    }

    public function setShippingRequestGateway(?ShipmentRequestGateway $shippingRequestGateway): self
    {
        $this->shippingRequestGateway = $shippingRequestGateway;

        return $this;
    }

    public function getDeliveryOrderApiId(): ?string
    {
        return $this->deliveryOrderApiId;
    }

    public function setDeliveryOrderApiId(?string $deliveryOrderApiId): self
    {
        $this->deliveryOrderApiId = $deliveryOrderApiId;

        return $this;
    }
}
