<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface MerchantOrderInterface
{
    public function getId(): int;

    public function getShippingAddressId(): int;

    public function setShippingAddressId(int $shippingAddressId): MerchantOrderInterface;

    public function getCarrierId(): int;

    public function setCarrierId(int $carrierId): MerchantOrderInterface;
    
    public function getCartId(): int;

    public function getTotalShippingTaxIncl(): float;
    
    public function setTotalShippingTaxIncl(float $shippingTotalTaxIncl): MerchantOrderInterface;

    public function getTotalShippingTaxExcl(): float;

    public function setTotalShippingTaxExcl(float $shippingTotalTaxExcl): MerchantOrderInterface;

    public function getTotalShipping(): float;

    public function setTotalShipping(float $shippingTotal): MerchantOrderInterface;

    public function getTotalPaidTaxIncl(): float;

    public function setTotalPaidTaxIncl(float $totalPaidTaxIncl): MerchantOrderInterface;

    public function getTotalPaidTaxExcl(): float;

    public function setTotalPaidTaxExcl(float $totalPaidTaxExcl): MerchantOrderInterface;

    public function getTotalPaid(): float;

    public function setTotalPaid(float $totalPaid): MerchantOrderInterface;

    public function getTotalProductsWt(): float;

    public function getTotalProducts(): float;
}
