<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface MerchantOrderAddressInterface
{
    public function getId(): int;

    public function getPhone(): string;

    public function setPhone(string $phone): MerchantOrderAddressInterface;

    public function getIdCountry(): int;

    public function setIdCountry(int $idCountry): MerchantOrderAddressInterface;

    public function getCity(): string;

    public function setCity(string $city): MerchantOrderAddressInterface;

    public function getStreet(): string;

    public function setStreet(string $street): MerchantOrderAddressInterface;

    public function getPostcode(): string;

    public function setPostcode(string $postcode): MerchantOrderAddressInterface;

    public function getIdCustomer(): int;

    public function setIdCustomer(int $idCustomer): MerchantOrderAddressInterface;

    public function getLastname(): string;

    public function setLastname(string $lastname): MerchantOrderAddressInterface;

    public function getFirstname(): string;

    public function setFirstname(string $firstname): MerchantOrderAddressInterface;

    public function setAlias(string $alias): MerchantOrderAddressInterface;
}
