<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Address;

class MerchantOrderAddress implements MerchantOrderAddressInterface
{
    /**
     * @var Address
     */
    private $address;

    public function __construct(Address $address)
    {
        $this->address = $address;
    }

    public function getAddress(): Address
    {
        return $this->address;
    }

    public function getId(): int
    {
        return (int)$this->address->id;
    }

    public function getPhone(): string
    {
        return $this->address->phone;
    }

    public function setPhone(string $phone): MerchantOrderAddressInterface
    {
        $this->address->phone = $phone;

        return $this;
    }

    public function getIdCountry(): int
    {
        return (int)$this->address->id_country;
    }

    public function setIdCountry(int $idCountry): MerchantOrderAddressInterface
    {
        $this->address->id_country = $idCountry;

        return $this;
    }

    public function getCity(): string
    {
        return $this->address->city;
    }

    public function setCity(string $city): MerchantOrderAddressInterface
    {
        $this->address->city = $city;

        return $this;
    }

    public function getStreet(): string
    {
        return $this->address->address1;
    }

    public function setStreet(string $street): MerchantOrderAddressInterface
    {
        $this->address->address1 = $street;

        return $this;
    }

    public function getPostcode(): string
    {
        return $this->address->postcode;
    }

    public function setPostcode(string $postcode): MerchantOrderAddressInterface
    {
        $this->address->postcode = $postcode;

        return $this;
    }

    public function getIdCustomer(): int
    {
        return (int)$this->address->id_customer;
    }

    public function setIdCustomer(int $idCustomer): MerchantOrderAddressInterface
    {
        $this->address->id_customer = $idCustomer;

        return $this;
    }

    public function getLastname(): string
    {
        return $this->address->lastname;
    }

    public function setLastname(string $lastname): MerchantOrderAddressInterface
    {
        $this->address->lastname = $lastname;

        return $this;
    }

    public function getFirstname(): string
    {
        return $this->address->firstname;
    }

    public function setFirstname(string $firstname): MerchantOrderAddressInterface
    {
        $this->address->firstname = $firstname;

        return $this;
    }

    public function setAlias(string $alias): MerchantOrderAddressInterface
    {
        $this->address->alias = $alias;

        return $this;
    }
}
