<?php
/**
 * 2018 Paysera
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author Paysera <plugins@paysera.com>
 * @copyright 2018 Paysera
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of Paysera
 */

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Order;

class MerchantOrder implements MerchantOrderInterface
{
    /**
     * @var Order
     */
    private $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function getId(): int
    {
        return $this->order->id;
    }

    public function getShippingAddressId(): int
    {
        return (int)$this->order->id_address_delivery;
    }

    public function setShippingAddressId(int $shippingAddressId): MerchantOrderInterface
    {
        $this->order->id_address_delivery = $shippingAddressId;

        return $this;
    }

    public function getOrder(): Order
    {
        return $this->order;
    }

    public function getCarrierId(): int
    {
        return (int)$this->order->id_carrier;
    }

    public function setCarrierId(int $carrierId): MerchantOrderInterface
    {
        $this->order->id_carrier = $carrierId;

        return $this;
    }

    public function getCartId(): int
    {
        return (int)$this->order->id_cart;
    }

    public function getTotalShipping(): float
    {
        return (float)$this->order->total_shipping;
    }

    public function setTotalShipping(float $shippingTotal): MerchantOrderInterface
    {
        $this->order->total_shipping = $shippingTotal;

        return $this;
    }

    public function getTotalPaidTaxIncl(): float
    {
        return (float)$this->order->total_paid_tax_incl;
    }

    public function setTotalPaidTaxIncl(float $totalPaidTaxIncl): MerchantOrderInterface
    {
        $this->order->total_paid_tax_incl = $totalPaidTaxIncl;

        return $this;
    }

    public function getTotalPaidTaxExcl(): float
    {
        return (float)$this->order->total_paid_tax_excl;
    }

    public function setTotalPaidTaxExcl(float $totalPaidTaxExcl): MerchantOrderInterface
    {
        $this->order->total_paid_tax_excl = $totalPaidTaxExcl;

        return $this;
    }

    public function getTotalProductsWt(): float
    {
        return (float)$this->order->total_products_wt;
    }

    public function getTotalProducts(): float
    {
        return (float)$this->order->total_products;
    }

    public function getTotalShippingTaxIncl(): float
    {
        return (float)$this->order->total_shipping_tax_excl;
    }

    public function setTotalShippingTaxIncl(float $shippingTotalTaxIncl): MerchantOrderInterface
    {
        $this->order->total_shipping_tax_excl = $shippingTotalTaxIncl;

        return $this;
    }

    public function getTotalShippingTaxExcl(): float
    {
        return (float)$this->order->total_shipping_tax_excl;
    }

    public function setTotalShippingTaxExcl(float $shippingTotalTaxExcl): MerchantOrderInterface
    {
        return $this;
    }

    public function getTotalPaid(): float
    {
        return $this->order->total_paid;
    }

    public function setTotalPaid(float $totalPaid): MerchantOrderInterface
    {
        $this->order->total_paid = $totalPaid;

        return $this;
    }
}
