<?php

namespace MadeSimple\Arrays;

/**
 * Class Dots
 *
 * @package MadeSimple\Arrays
 */
class Dots implements \ArrayAccess, \MadeSimple\Arrays\Arrayable
{
    /**
     * @var array
     */
    private $array;
    /**
     * DotArr constructor.
     *
     * @param array  $array
     */
    function __construct(array $array = [])
    {
        $this->setArray($array);
    }
    /**
     * Store an array.
     *
     * @param array  $array
     */
    public function setArray(array $array)
    {
        if (\MadeSimple\Arrays\Arr::accessible($array)) {
            $this->array = $array;
        }
    }
    /**
     * Get the instance as an array.
     *
     * @return array
     */
    public function toArray()
    {
        return $this->array;
    }
    /**
     * Store an array as a reference.
     *
     * @param array  $array
     */
    public function setReference(&$array)
    {
        if (\MadeSimple\Arrays\Arr::isAssoc($array)) {
            $this->array =& $array;
        }
    }
    public function offsetExists($offset)
    {
        return \MadeSimple\Arrays\ArrDots::has($this->array, $offset);
    }
    public function offsetGet($offset)
    {
        return \MadeSimple\Arrays\ArrDots::get($this->array, $offset);
    }
    public function offsetSet($offset, $value)
    {
        \MadeSimple\Arrays\ArrDots::set($this->array, $offset, $value);
    }
    public function offsetUnset($offset)
    {
        \MadeSimple\Arrays\ArrDots::remove($this->array, $offset);
    }
}
