<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Helper;

use Paysera\Delivery\Entity\ShipmentRequest;
use Paysera\Delivery\Entity\ShipmentRequestGateway;
use Paysera\Delivery\Exception\MissingShippingMethodArgument;
use Paysera\Delivery\Model\ShipmentRequestModel;

class ShipmentRequestHelper
{
    /**
     * @var ShipmentRequestModel
     */
    private $shipmentRequestModel;

    public function __construct(ShipmentRequestModel $shipmentRequestModel)
    {
        $this->shipmentRequestModel = $shipmentRequestModel;
    }

    public function saveFromProperties(
        string $orderId,
        ?string $shippingMethod = null,
        ?ShipmentRequestGateway $gateway = null
    ): void {
        $shipmentRequest = $this->shipmentRequestModel->get($orderId);
        if ($shipmentRequest !== null) {
            if ($shippingMethod !== null) {
                $shipmentRequest->setShippingMethod($shippingMethod);
            }
            if ($gateway !== null) {
                $shipmentRequest->setShippingRequestGateway($gateway);
            }

            $this->shipmentRequestModel->update($shipmentRequest);

            return;
        }

        if ($shippingMethod === null) {
            throw new MissingShippingMethodArgument();
        }

        $shipmentRequest = new ShipmentRequest($orderId, $shippingMethod, ShipmentRequest::STATUS_NEW, $gateway);
        $this->shipmentRequestModel->create($shipmentRequest);
    }
}
