<?php

declare(strict_types=1);

namespace Paysera\Delivery\Manager;

use Paysera\Delivery\Entity\ShipmentRequest;
use Paysera\Delivery\Model\ShipmentRequestModel;

class ShipmentRequestManager
{
    /**
     * @var ShipmentRequestModel
     */
    private $shipmentRequestModel;

    public function __construct(ShipmentRequestModel $shipmentRequestModel)
    {
        $this->shipmentRequestModel = $shipmentRequestModel;
    }

    public function markAsCompleted(ShipmentRequest $shipmentRequest): void
    {
        $shipmentRequest->setStatus(ShipmentRequest::STATUS_COMPLETED);
        $this->shipmentRequestModel->update($shipmentRequest);
    }
}
