<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class ShipmentRequest
{
    public const STATUS_NEW = 'new';
    public const STATUS_COMPLETED = 'completed';

    /**
     * @var string
     */
    private $orderId;

    /**
     * @var string
     */
    private $shippingMethod;

    /**
     * @var string
     */
    private $status;

    /**
     * @var ?ShipmentRequestGateway
     */
    private $shippingRequestGateway;

    public function __construct(
        string $orderId,
        string $shippingMethod,
        string $status,
        ?ShipmentRequestGateway $shipmentRequestGateway = null
    ) {
        $this->orderId = $orderId;
        $this->shippingMethod = $shippingMethod;
        $this->status = $status;
        $this->shippingRequestGateway = $shipmentRequestGateway;
    }

    public function getOrderId(): string
    {
        return $this->orderId;
    }

    public function getShippingMethod(): string
    {
        return $this->shippingMethod;
    }

    public function setShippingMethod(string $shippingMethod): self
    {
        $this->shippingMethod = $shippingMethod;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getShippingRequestGateway(): ?ShipmentRequestGateway
    {
        return $this->shippingRequestGateway;
    }

    public function setShippingRequestGateway(?ShipmentRequestGateway $shippingRequestGateway): self
    {
        $this->shippingRequestGateway = $shippingRequestGateway;

        return $this;
    }
}
