<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class Product
{
    /**
     * @var int
     */
    private $quantity;

    /**
     * @var float
     */
    private $weight;

    /**
     * @var int
     */
    private $weightClassId;

    /**
     * @var float
     */
    private $length;

    /**
     * @var int
     */
    private $lengthClassId;

    /**
     * @var float
     */
    private $width;

    /**
     * @var float
     */
    private $height;

    public function __construct(
        int $quantity,
        float $weight,
        int $weightClassId,
        float $length,
        int $lengthClassId,
        float $width,
        float $height
    ) {
        $this->quantity = $quantity;
        $this->weight = $weight;
        $this->weightClassId = $weightClassId;
        $this->length = $length;
        $this->lengthClassId = $lengthClassId;
        $this->width = $width;
        $this->height = $height;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }

    public function getWeight(): float
    {
        return $this->weight;
    }

    public function getWeightClassId(): int
    {
        return $this->weightClassId;
    }

    public function getLength(): float
    {
        return $this->length;
    }

    public function getLengthClassId(): int
    {
        return $this->lengthClassId;
    }

    public function getWidth(): float
    {
        return $this->width;
    }

    public function getHeight(): float
    {
        return $this->height;
    }
}
