<?php

namespace Paysera\Delivery\Entity;

class DeliverySettings
{
    private ?int $projectId;

    private ?string $projectPassword;

    private ?string $projectHash;

    private ?int $orderStatus;

    private bool $testModeEnabled;

    private bool $statusEnabled;

    private array $deliveryGateways;

    public function __construct()
    {
        $this->projectId = null;
        $this->projectPassword = null;
        $this->projectHash = null;
        $this->orderStatus = null;
        $this->testModeEnabled = false;
        $this->statusEnabled = false;
        $this->deliveryGateways = [];
    }


    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(int $projectId): DeliverySettings
    {
        $this->projectId = $projectId;

        return $this;
    }

    public function getProjectPassword(): ?string
    {
        return $this->projectPassword;
    }

    public function setProjectPassword(string $projectPassword): DeliverySettings
    {
        $this->projectPassword = $projectPassword;

        return $this;
    }

    public function getProjectHash(): ?string
    {
        return $this->projectHash;
    }

    public function setProjectHash(string $projectHash): DeliverySettings
    {
        $this->projectHash = $projectHash;

        return $this;
    }

    public function getOrderStatus(): ?int
    {
        return $this->orderStatus;
    }

    public function setOrderStatus(int $orderStatus): DeliverySettings
    {
        $this->orderStatus = $orderStatus;

        return $this;
    }

    public function isTestModeEnabled(): bool
    {
        return $this->testModeEnabled;
    }

    public function setTestModeEnabled(bool $testModeEnabled): DeliverySettings
    {
        $this->testModeEnabled = $testModeEnabled;

        return $this;
    }

    public function isStatusEnabled(): bool
    {
        return $this->statusEnabled;
    }

    public function setStatusEnabled(bool $statusEnabled): DeliverySettings
    {
        $this->statusEnabled = $statusEnabled;

        return $this;
    }

    public function getDeliveryGateways(): array
    {
        return $this->deliveryGateways;
    }

    public function setDeliveryGateways(array $deliveryGateways): DeliverySettings
    {
        $this->deliveryGateways = $deliveryGateways;

        return $this;
    }
}
