$(document).ready(function() {
    let select_country = $('#input-gateway-delivery-country');
    let select_city = $('#input-gateway-delivery-city');
    let select_terminal = $('#input-gateway-delivery-terminal');
    let btn_shipping_method = $('#button-shipping-methods');
    let btn_payment_methods = $('button#button-payment-methods');
    let route = 'extension/paysera_delivery/shipping/paysera' + OpenCartRouteActionSeparator;
    let url = 'index.php';

    select_country.select2();
    select_city.select2();
    select_terminal.select2();

    function shippingMethodChanged() {
        let delivery_gateway_code = getShippingMethod();
        let delivery_gateway_content = $('.paysera-delivery-gateway-content');
        let delivery_gateway_warning_content = $('.paysera-delivery-gateway-warning');

        getConfirmButton().prop('disabled', true);

        if (delivery_gateway_code.startsWith('paysera.')) {
            delivery_gateway_code = delivery_gateway_code.replace('paysera.', '');
            $('#checkout-shipping-method').after(delivery_gateway_content);
            $('#checkout-shipping-method').after(delivery_gateway_warning_content);
            btn_shipping_method.prop('disabled', false);
            btn_payment_methods.prop('disabled', true);

            $.ajax({
                url,
                data: {
                    route: route + 'validate',
                    delivery_gateway_code
                }
            })
                .done(function (response) {
                    if (response.error) {
                        delivery_gateway_warning_content.removeClass('hidden');
                        delivery_gateway_warning_content.html(response.error);
                        delivery_gateway_content.addClass('hidden');
                        btn_shipping_method.prop('disabled', false);
                    } else {
                        delivery_gateway_content.addClass('hidden');
                        delivery_gateway_warning_content.addClass('hidden');
                        btn_shipping_method.prop('disabled', false);
                        btn_payment_methods.prop('disabled', false);
                    }

                    if (response.has_delivery_terminal === 1) {
                        btn_payment_methods.prop('disabled', true);
                        clearPaymentMethod();
                        if (!response.error) {
                            $.ajax({
                                url,
                                data: {
                                    route: route + 'getCountryByGatewayCode',
                                    delivery_gateway_code
                                }
                            }).done(function (response) {
                                delivery_gateway_content.html(response);
                                btn_shipping_method.prop('disabled', false);
                            });
                            select_city.parent().parent().addClass('hidden');
                            select_terminal.parent().parent().addClass('hidden');

                            delivery_gateway_warning_content.addClass('hidden');
                            delivery_gateway_content.removeClass('hidden');
                        }
                    }
                });
        } else {
            delivery_gateway_content.addClass('hidden');
            delivery_gateway_warning_content.addClass('hidden');
            btn_shipping_method.prop('disabled', false);
            btn_payment_methods.prop('disabled', false);
        }
    }

    shippingMethodChanged();
    // For OC v >= 4.0.2.0
    $(document).on('submit', '#form-shipping-method', () => setTimeout(shippingMethodChanged, 100));
    // For OC < 4.0.2.0
    $(document).on('change', 'select#input-shipping-method', () => setTimeout(shippingMethodChanged, 100));

    function getShippingMethod() {
        return $('input[name=shipping_method]:checked').val()
            || $('#input-shipping-code').val()
            || $('select#input-shipping-method').val()  // For OC < 4.0.2.0
            || '';
    }

    function getConfirmButton() {
        // this method is necessary because of the OC removes the button from the DOM and creates new one at some moment
        return $('button#button-confirm');
    }

    function clearPaymentMethod() {
        $('select#input-payment-method').val('').prop('disabled', true);
    }
});
