<?php

declare(strict_types=1);

use Paysera\Delivery\PayseraDeliverySettings;

return [
    'events' => [
        [
            'code' => 'paysera_delivery_store_admin_startup',
            'trigger' => PayseraDeliverySettings::EVENT_ADMIN_STARTUP,
            'action' => 'payseraDeliveryOpenCartStartupHandler',
            'description' => 'Admin startup event for Paysera delivery initialization',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_menu',
            'trigger' => PayseraDeliverySettings::EVENT_ADMIN_MENU,
            'action' => 'payseraDeliveryMenuHandler',
            'description' => 'Add Paysera delivery menu to admin panel',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_shipping_method',
            'trigger' => PayseraDeliverySettings::EVENT_SHIPPING_METHOD_VIEW,
            'action' => 'shippingMethods',
            'description' => 'Display Paysera delivery shipping methods in checkout',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_create_order',
            'trigger' => PayseraDeliverySettings::EVENT_CREATE_ORDER_AFTER,
            'action' => 'createDeliveryOrder',
            'description' => 'Create delivery order when checkout is completed',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_payment_confirmed',
            'trigger' => PayseraDeliverySettings::EVENT_PAYMENT_CONFIRMED,
            'action' => 'payseraPaymentConfirmed',
            'description' => 'Handle payment confirmation for delivery orders',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_shipping_method_save_before',
            'trigger' => PayseraDeliverySettings::EVENT_SHIPPING_METHOD_SAVE,
            'action' => 'shippingMethodSave',
            'description' => 'Process shipping method selection in checkout',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_add_shipping_logo_before_checkout_total',
            'trigger' => PayseraDeliverySettings::EVENT_CHECKOUT_GET_TOTAL_BEFORE,
            'action' => 'addShippingMethodLogo',
            'description' => 'Adds shipping method logo to the totals in the checkout',
            'status' => true,
            'sort_order' => 1,
        ],
        [
            'code' => 'paysera_delivery_remove_shipping_logo_after_checkout_total',
            'trigger' => PayseraDeliverySettings::EVENT_CHECKOUT_GET_TOTAL_AFTER,
            'action' => 'removeShippingMethodLogo',
            'description' => 'Rollback paysera_delivery_add_shipping_logo_before_checkout_total',
            'status' => true,
            'sort_order' => 1,
        ],
    ],
];
