<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service;

use Paysera\Delivery\Entity\Order;
use Paysera\DeliveryApi\MerchantClient\Entity\Party;

class PartyCreator
{
    public function createReceiverParty(Order $order): Party
    {
        $partyTitle = $order->getPaymentFirstName() . ' ' . $order->getPaymentLastName();
        if (trim($partyTitle) === '') {
            $partyTitle = $order->getShippingFirstName() . ' ' . $order->getShippingLastName();
        }

        return (new Party())
            ->setTitle(trim($partyTitle))
            ->setEmail($order->getEmail())
            ->setPhone($order->getTelephone())
        ;
    }
}
