<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Event;

use Paysera\Delivery\Exception\UnsupportedVersionException;
use Paysera\Delivery\ValueObject\OpenCartVersion;

class EventRegistrarFactory
{
    private EventAdapterFactory $adapterFactory;

    public function __construct(EventAdapterFactory $adapterFactory)
    {
        $this->adapterFactory = $adapterFactory;
    }

    /**
     * @throws UnsupportedVersionException
     */
    public function create(OpenCartVersion $version, $eventSettingModel): EventRegistrar
    {
        $eventAdapter = $this->createEventAdapter($version);

        return new EventRegistrar($eventAdapter, $eventSettingModel);
    }

    /**
     * @throws UnsupportedVersionException
     */
    public function createInterface(OpenCartVersion $version, $eventSettingModel): EventRegistrarInterface
    {
        return $this->create($version, $eventSettingModel);
    }

    public function getSupportedVersions(): array
    {
        return array_map(
            fn(string $version) => new OpenCartVersion($version),
            $this->adapterFactory->getSupportedVersions()
        );
    }

    public function isVersionSupported(OpenCartVersion $version): bool
    {
        try {
            $this->adapterFactory->create($version->toString());
            return true;
        } catch (UnsupportedVersionException $e) {
            return false;
        }
    }

    /**
     * @throws UnsupportedVersionException
     */
    private function createEventAdapter(OpenCartVersion $version): EventAdapterInterface
    {
        return $this->adapterFactory->create($version->toString());
    }
}
