<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Event;

use Paysera\Delivery\Entity\Event;

class EventRegistrar implements EventRegistrarInterface
{
    private EventAdapterInterface $eventAdapter;
    private $eventSettingModel;

    public function __construct(EventAdapterInterface $eventAdapter, $eventSettingModel)
    {
        $this->eventAdapter = $eventAdapter;
        $this->eventSettingModel = $eventSettingModel;
    }

    public function registerEvent(Event $event): void
    {
        $this->eventAdapter->registerEvent($event, $this->eventSettingModel);
    }

    public function removeEvent(string $eventCode): void
    {
        $this->eventSettingModel->deleteEventByCode($eventCode);
    }

    public function getEventAdapter(): EventAdapterInterface
    {
        return $this->eventAdapter;
    }

    public function getSupportedVersion(): string
    {
        return $this->eventAdapter->getSupportedVersion();
    }
}
