<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Event\EventAdapter;

use Paysera\Delivery\Service\Event\EventAdapterInterface;
use Paysera\Delivery\Entity\Event;

class OpenCartV4103EventAdapter implements EventAdapterInterface
{
    public const SUPPORTED_VERSION = '4.1.0.3';

    public function registerEvent(Event $event, $eventSettingModel): void
    {
        $eventSettingModel->addEvent($this->convertToArray($event));
    }

    public function getSupportedVersion(): string
    {
        return self::SUPPORTED_VERSION;
    }

    /**
     * @return array{
     *     code: string,
     *     trigger: string,
     *     action: string,
     *     description: string,
     *     status: bool,
     *     sort_order: int
     * }
     */
    private function convertToArray(Event $event): array
    {
        return [
            'code' => $event->getCode(),
            'trigger' => $event->getTrigger(),
            'action' => $event->getAction(),
            'description' => $event->getDescription(),
            'status' => $event->isStatus(),
            'sort_order' => $event->getSortOrder(),
        ];
    }
}
