<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Event\EventAdapter;

use Paysera\Delivery\Service\Event\EventAdapterInterface;
use Paysera\Delivery\Entity\Event;

class OpenCartV4010EventAdapter implements EventAdapterInterface
{
    public const SUPPORTED_VERSION = '4.0.1.0';

    public function registerEvent(Event $event, $eventSettingModel): void
    {
        $eventData = $this->convertToArray($event);
        $eventData['trigger'] = $this->convertToSlashNotation($eventData['trigger']);

        $eventSettingModel->addEvent($eventData);
    }

    public function getSupportedVersion(): string
    {
        return self::SUPPORTED_VERSION;
    }

    private function convertToSlashNotation(string $trigger): string
    {
        return str_replace('.', '/', $trigger);
    }

    private function convertToArray(Event $event): array
    {
        return [
            'code' => $event->getCode(),
            'trigger' => $event->getTrigger(),
            'action' => $event->getAction(),
            'description' => $event->getDescription(),
            'status' => $event->isStatus(),
            'sort_order' => $event->getSortOrder(),
        ];
    }
}
