<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\Event\EventAdapter;

use Paysera\Delivery\Service\Event\EventAdapterInterface;
use Paysera\Delivery\Entity\Event;

class OpenCartV4000EventAdapter implements EventAdapterInterface
{
    public const SUPPORTED_VERSION = '4.0.0.0';

    public function registerEvent(Event $event, $eventSettingModel): void
    {
        $eventSettingModel->addEvent(
            $event->getCode(),
            $event->getDescription(),
            $this->convertToSlashNotation($event->getTrigger()),
            $event->getAction(),
            $event->isStatus() ? 1 : 0,
            $event->getSortOrder()
        );
    }

    public function getSupportedVersion(): string
    {
        return self::SUPPORTED_VERSION;
    }

    private function convertToSlashNotation(string $trigger): string
    {
        return str_replace('.', '/', $trigger);
    }
}
