<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService\Polyfill\Version;

use Opencart\System\Library\Session;
use Opencart\System\Engine\Config;
use Opencart\System\Library\DB;
use Opencart\System\Engine\Proxy;
use Paysera\Delivery\Service\CompatibilityService\Polyfill\AbstractPolyfill;

/**
 * Polyfill for OpenCart version 4.0.2.0
 *
 * Introduces changes to session shipping method handling and country retrieval.
 */
class Polyfill4_0_2_0 extends AbstractPolyfill
{
    public const VERSION = '4.0.2.0';

    public function addShippingMethodLogo(Session $session): void
    {
        if (!isset($session->data['shipping_method'])) {
            return;
        }

        // Check if this is a Paysera shipping method
        $code = $session->data['shipping_method']['code'] ?? null;
        if ($code === null || !str_starts_with($code, 'paysera.')) {
            return;
        }

        // Check if nameWithLogo field exists before using it
        if (!isset($session->data['shipping_method']['nameWithLogo'])) {
            return;
        }

        $session->data['shipping_method']['name'] = $session->data['shipping_method']['nameWithLogo'];
    }

    public function removeShippingMethodLogo(Session $session): void
    {
        if (!isset($session->data['shipping_method'])) {
            return;
        }

        // Check if this is a Paysera shipping method
        $code = $session->data['shipping_method']['code'] ?? null;
        if ($code === null || !str_starts_with($code, 'paysera.')) {
            return;
        }

        // Check if plainName field exists before using it
        if (!isset($session->data['shipping_method']['plainName'])) {
            return;
        }

        $session->data['shipping_method']['name'] = $session->data['shipping_method']['plainName'];
    }

    public function getCountryByIsoCode2(
        string $iso_code_2,
        Config $config,
        DB $db,
        Proxy $modelLocalizationCountry
    ): ?array {
        $country = $modelLocalizationCountry->getCountryByIsoCode2($iso_code_2);

        return $country[0] ?? $country;
    }

    public function getVersion(): string
    {
        return self::VERSION;
    }
}
