<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService\Polyfill;

use Opencart\System\Library\Session;
use Opencart\System\Library\Cart\Weight;
use Opencart\System\Engine\Config;
use Opencart\System\Library\DB;
use Opencart\System\Engine\Proxy;

/**
 * Abstract base class for all polyfill implementations.
 * Provides common functionality and default implementations where appropriate.
 */
abstract class AbstractPolyfill implements PolyfillInterface
{
    /**
     * Default implementation - no operation needed for older versions.
     */
    public function addShippingMethodLogo(Session $session): void
    {
        // Default implementation does nothing
    }

    /**
     * Default implementation - no operation needed for older versions.
     */
    public function removeShippingMethodLogo(Session $session): void
    {
        // Default implementation does nothing
    }

    /**
     * Default implementation using direct database query (legacy approach).
     */
    public function getCountryByIsoCode2(
        string $iso_code_2,
        Config $config,
        DB $db,
        Proxy $modelLocalizationCountry
    ): ?array {
        $query = $db->query(
            "SELECT * FROM `" . DB_PREFIX . "country` WHERE `iso_code_2` = '" .
            $db->escape($iso_code_2) . "' AND `status` = '1'"
        );

        return $query->row ?? null;
    }

    /**
     * Default implementation using Weight::getUnit() method.
     */
    public function getDefaultUnit(string $unitId, Weight $weight): string|int
    {
        return $weight->getUnit((int)$unitId);
    }

    /**
     * Get the version this polyfill is designed for.
     * Must be implemented by concrete classes.
     */
    abstract public function getVersion(): string;
}
