<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService;

use Paysera\Delivery\Service\CompatibilityService\Polyfill\Polyfill;
use Paysera\Delivery\Service\CompatibilityService\Polyfill\PolyfillFactory;
use Paysera\Delivery\Service\Event\EventRegistrarFactory;
use Paysera\Delivery\Service\Event\EventAdapterFactory;
use Paysera\Delivery\ValueObject\OpenCartVersion;

class PayseraCompatibilityServiceFactory
{
    private PolyfillFactory $polyfillFactory;
    private RoutePathResolverFactory $routePathResolverFactory;
    private EventAdapterFactory $eventAdapterFactory;

    public function __construct()
    {
        $this->polyfillFactory = new PolyfillFactory();
        $this->routePathResolverFactory = new RoutePathResolverFactory();
        $this->eventAdapterFactory = new EventAdapterFactory();
    }

    public function create(string $ocVersionString): PayseraCompatibilityService
    {
        $ocVersion = new OpenCartVersion($ocVersionString);

        return new PayseraCompatibilityService(
            $ocVersion,
            new Polyfill($ocVersion, $this->polyfillFactory),
            $this->routePathResolverFactory,
            new CompatibilityAdapterFactory(
                $this->routePathResolverFactory,
                new EventRegistrarFactory($this->eventAdapterFactory)
            )
        );
    }
}
