<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService;

use Paysera\Delivery\Service\CompatibilityService\Polyfill\Polyfill;
use Paysera\Delivery\Exception\UnsupportedVersionException;
use Paysera\Delivery\ValueObject\OpenCartVersion;

class PayseraCompatibilityService
{
    private Polyfill $polyfill;
    private RoutePathResolverFactory $routePathResolverFactory;
    private CompatibilityAdapterFactory $adapterFactory;
    private OpenCartVersion $ocVersion;
    private array $adapterCache;

    public function __construct(
        OpenCartVersion $ocVersion,
        Polyfill $polyfill,
        RoutePathResolverFactory $routePathResolverFactory,
        CompatibilityAdapterFactory $adapterFactory
    ) {
        $this->adapterCache = [];
        $this->polyfill = $polyfill;
        $this->routePathResolverFactory = $routePathResolverFactory;
        $this->adapterFactory = $adapterFactory;
        $this->ocVersion = $ocVersion;
    }

    public function polyfill(): Polyfill
    {
        return $this->polyfill;
    }

    /**
     * @throws UnsupportedVersionException
     */
    public function getCurrentOCVersionAdapter($modelSettingEvent): CompatibilityAdapterInterface
    {
        $cacheKey = $this->ocVersion->toString() . '_' . spl_object_hash($modelSettingEvent);

        if (!isset($this->adapterCache[$cacheKey])) {
            $this->adapterCache[$cacheKey] = $this->adapterFactory->create(
                $this->ocVersion,
                $modelSettingEvent
            );
        }

        return $this->adapterCache[$cacheKey];
    }

    public function getRoutePathResolverFactory(): RoutePathResolverFactory
    {
        return $this->routePathResolverFactory;
    }

    public function getRoutePathResolver(): RoutePathResolverInterface
    {
        return $this->routePathResolverFactory->create($this->ocVersion);
    }
}
