<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService;

use Paysera\Delivery\Entity\Event;
use Paysera\Delivery\Provider\EventsProvider;
use Paysera\Delivery\Service\Event\EventRegistrarInterface;
use Paysera\Delivery\ValueObject\OpenCartVersion;

class OpencartVersionAdapter implements PayseraCompatibilityAdapterInterface
{
    private RoutePathResolverInterface $routePathResolver;
    private EventsProvider $eventsProvider;
    private EventRegistrarInterface $eventRegistrar;
    private OpenCartVersion $version;

    public function __construct(
        RoutePathResolverInterface $routePathResolver,
        EventsProvider $eventsProvider,
        EventRegistrarInterface $eventRegistrar,
        OpenCartVersion $version
    ) {
        $this->routePathResolver = $routePathResolver;
        $this->eventsProvider = $eventsProvider;
        $this->eventRegistrar = $eventRegistrar;
        $this->version = $version;
    }

    public function getRoutePathResolver(): RoutePathResolverInterface
    {
        return $this->routePathResolver;
    }

    public function getVersion(): OpenCartVersion
    {
        return $this->version;
    }

    public function registerEvents(): void
    {
        foreach ($this->eventsProvider->getEvents() as $event) {
            $preparedEvent = $this->prepareEvent($event);
            $this->eventRegistrar->registerEvent($preparedEvent);
        }
    }

    public function removeEvents(): void
    {
        foreach ($this->eventsProvider->getEvents() as $event) {
            $this->eventRegistrar->removeEvent($event->getCode());
        }
    }

    private function prepareEvent(Event $event): Event
    {
        $preparedEvent = clone $event;
        $compatibleAction = $this->routePathResolver->getCompatibleRoutePath($event->getAction());
        $preparedEvent->setAction($compatibleAction);

        return $preparedEvent;
    }
}
