<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService;

use Paysera\Delivery\Entity\Event;
use Paysera\Delivery\ValueObject\OpenCartVersion;

interface CompatibilityAdapterInterface
{
    public function getRoutePathResolver(): RoutePathResolverInterface;

    /**
     * @param Event[] $events
     */
    public function registerEvents(array $events): void;

    /**
     * @param string[] $eventCodes
     */
    public function removeEvents(array $eventCodes): void;

    public function getVersion(): OpenCartVersion;
}
