<?php

declare(strict_types=1);

namespace Paysera\Delivery\Service\CompatibilityService;

use Paysera\Delivery\Service\Event\EventRegistrarFactory;
use Paysera\Delivery\ValueObject\OpenCartVersion;

class CompatibilityAdapterFactory
{
    private RoutePathResolverFactory $routePathResolverFactory;
    private EventRegistrarFactory $eventRegistrarFactory;

    public function __construct(
        RoutePathResolverFactory $routePathResolverFactory,
        EventRegistrarFactory $eventRegistrarFactory
    ) {
        $this->routePathResolverFactory = $routePathResolverFactory;
        $this->eventRegistrarFactory = $eventRegistrarFactory;
    }

    public function create(OpenCartVersion $version, $modelSettingEvent): CompatibilityAdapterInterface
    {
        $routePathResolver = $this->routePathResolverFactory->create($version);
        $eventRegistrar = $this->eventRegistrarFactory->create($version, $modelSettingEvent);

        return new CompatibilityAdapter(
            $routePathResolver,
            $eventRegistrar,
            $version
        );
    }
}
