<?php

declare(strict_types=1);

namespace Paysera\Delivery\Provider;

use Paysera\Delivery\Entity\Event;
use Paysera\Delivery\Factory\EventFactory;
use Paysera\Delivery\Service\ConfigLoader;
use Paysera\Delivery\Exception\ConfigurationNotFoundException;

class EventsProvider
{
    private EventFactory $eventFactory;
    private ConfigLoader $configLoader;
    private ?array $cachedEvents = null;

    public function __construct(
        EventFactory $eventFactory = null,
        ConfigLoader $configLoader = null
    ) {
        $this->eventFactory = $eventFactory ?? new EventFactory();
        $this->configLoader = $configLoader ?? new ConfigLoader();
    }

    /**
     * @return Event[]
     * @throws ConfigurationNotFoundException
     */
    public function getEvents(): array
    {
        if ($this->cachedEvents === null) {
            $this->cachedEvents = $this->loadEventsFromConfig();
        }

        return $this->cachedEvents;
    }

    /**
     * @return Event[]
     * @throws ConfigurationNotFoundException
     */
    private function loadEventsFromConfig(): array
    {
        $eventsConfig = $this->configLoader->loadEventsConfig();
        return $this->eventFactory->createFromArrayCollection($eventsConfig);
    }
}
