<?php

namespace Paysera\Delivery;

class PayseraDeliverySettings
{
    const SETTINGS_NAME = 'shipping_paysera';
    const SETTINGS_EXTENSION_STATUS_NAME = 'shipping_paysera_status';

    const STATUS = 'shipping_paysera_status';
    const TEST_MODE = 'shipping_paysera_test';
    const DELIVERY_GATEWAY = 'shipping_paysera_delivery_gateway';
    const PROJECT_ID  = 'shipping_paysera_project_id';
    const PROJECT_HASH  = 'shipping_paysera_project_hash';
    const PROJECT_PASSWORD  = 'shipping_paysera_project_password';

    const TITLE = 'title';
    const DESCRIPTION = 'description';
    const MAXIMUM_WEIGHT = 'maximum_weight';
    const MINIMUM_WEIGHT = 'minimum_weight';
    const FEE = 'fee';
    const SENDER_TYPE = 'sender_type';
    const RECEIVER_TYPE = 'receiver_type';
    const FREE_DELIVERY_THRESHOLD = 'free_delivery_threshold';
    const SORT_ORDER = 'sort_order';
    const SHIPMENT_GATEWAY = 'shipment_gateway';
    const GEO_ZONE = 'geo_zone';
    const TAX_CLASS_ID = 'tax_class_id';

    const DEFAULT_MAXIMUM_WEIGHT = 10;
    const DEFAULT_MINIMUM_WEIGHT = 0;
    const DEFAULT_FEE = 0;
    const DEFAULT_FREE_DELIVERY_THRESHOLD = 0;
    const DEFAULT_SENDER_TYPE = self::TYPE_COURIER;

    const LANGUAGE_ABOUT = 'extension/paysera_delivery/paysera/about';
    const LANGUAGE_NO_PLUGIN = 'extension/paysera_delivery/paysera/no_payment_plugin';
    const LANGUAGE_SETTINGS = 'extension/paysera_delivery/shipping/paysera';
    const LANGUAGE_DELIVERY_GATEWAY = 'extension/paysera_delivery/paysera/delivery_gateway';

    const SHIPPING_METHOD_PREFIX = 'paysera';

    const WEIGHT_CLASS_FALLBACK_ID = 0;
    const LENGTH_CLASS_FALLBACK_ID = 0;

    const TYPE_COURIER = 'courier';
    const TYPE_PARCEL_MACHINE = 'parcel-machine';
    const AVAILABLE_TYPES = [
        self::TYPE_COURIER => self::LANGUAGE_TYPE_COURIER_KEY,
        self::TYPE_PARCEL_MACHINE => self::LANGUAGE_TYPE_PARCEL_LOCKER_KEY,
    ];

    const TERMINAL = 'terminal';

    const LANGUAGE_TYPE_COURIER_KEY = 'text_courier';
    const LANGUAGE_TYPE_PARCEL_LOCKER_KEY = 'text_parcel_locker';
    const LANGUAGE_TERMINAL_KEY = 'text_terminal';

    public const EXTENSION_VERSION_KEY = 'shipping_paysera_status_extension_installed_version';
    public const OPENCART_VERSION_KEY = 'shipping_paysera_status_opencart_version';

    const EVENT_PAYMENT_CONFIRMED = 'catalog/extension/oc_paysera/payment_callback/success';
    const EVENT_CREATE_ORDER_AFTER = 'catalog/model/checkout/order.addOrder/after';
    const EVENT_SHIPPING_METHOD_SAVE = 'catalog/controller/checkout/shipping_method.save/before';
    const EVENT_CHECKOUT_GET_TOTAL_BEFORE = 'catalog/model/extension/opencart/total/shipping.getTotal/before';
    const EVENT_CHECKOUT_GET_TOTAL_AFTER = 'catalog/model/extension/opencart/total/shipping.getTotal/after';
    const EVENT_ADMIN_STARTUP = 'admin/model/setting/store.getStores/before';
    const EVENT_ADMIN_MENU = 'admin/view/common/column_left/before';
    const EVENT_SHIPPING_METHOD_VIEW = 'catalog/view/checkout/shipping_method/after';
}
