<?php

namespace Paysera\Delivery\Normalizer;

use Paysera\DeliveryApi\MerchantClient\Entity\ShipmentGateway;

class ShipmentGatewayNormalizer
{
    const KEY_ID = 'id';
    const KEY_CODE = 'code';
    const KEY_DESCRIPTION = 'description';
    const KEY_ENABLED = 'enabled';
    const KEY_LOGO = 'logo';

    /**
     * @param ShipmentGateway $shipmentGateway
     * @return array
     */
    public function mapFromEntity($shipmentGateway)
    {
        return [
            self::KEY_ID => $shipmentGateway->getId(),
            self::KEY_CODE => $shipmentGateway->getCode(),
            self::KEY_DESCRIPTION => $shipmentGateway->getDescription(),
            self::KEY_LOGO => $shipmentGateway->getLogo(),
            self::KEY_ENABLED => $shipmentGateway->isEnabled(),
        ];
    }

    /**
     * @param array $shipmentGateway
     * @return ShipmentGateway
     */
    public function mapToEntity($shipmentGateway)
    {
        return (new ShipmentGateway())
            ->setId($shipmentGateway[self::KEY_ID])
            ->setCode($shipmentGateway[self::KEY_CODE])
            ->setDescription($shipmentGateway[self::KEY_DESCRIPTION])
            ->setLogo($shipmentGateway[self::KEY_LOGO])
            ->setEnabled($shipmentGateway[self::KEY_ENABLED])
        ;
    }
}
