<?php

declare(strict_types=1);

namespace Paysera\Delivery\Normalizer;

use Paysera\Delivery\Entity\Product;

class ProductNormalizer
{
    public function mapToEntity(array $product): Product
    {
        return new Product(
            (int) $product['quantity'],
            (float) $product['weight'],
            (int) $product['weight_class_id'],
            (float) $product['length'],
            (int) $product['length_class_id'],
            (float) $product['width'],
            (float) $product['height']
        );
    }
}
