<?php

namespace Paysera\Delivery\Normalizer;

use Paysera\Delivery\Entity\DeliverySettings;
use Paysera\Delivery\PayseraDeliverySettings;

class DeliverySettingsNormalizer
{
    public function mapToEntity(array $settings): DeliverySettings
    {
        $deliverySettings = new DeliverySettings();

        if (isset($settings[PayseraDeliverySettings::PROJECT_ID])) {
            $deliverySettings->setProjectId((int) $settings[PayseraDeliverySettings::PROJECT_ID]);
        }

        if (isset($settings[PayseraDeliverySettings::PROJECT_PASSWORD])) {
            $deliverySettings->setProjectPassword($settings[PayseraDeliverySettings::PROJECT_PASSWORD]);
        }

        if (isset($settings[PayseraDeliverySettings::PROJECT_HASH])) {
            $deliverySettings->setProjectHash($settings[PayseraDeliverySettings::PROJECT_HASH]);
        }

        if (isset($settings[PayseraDeliverySettings::TEST_MODE])) {
            $deliverySettings->setTestModeEnabled(
                (int) $settings[PayseraDeliverySettings::TEST_MODE] === 1
            );
        }

        $deliverySettings->setDeliveryGateways($settings[PayseraDeliverySettings::DELIVERY_GATEWAY] ?? []);
        $deliverySettings->setStatusEnabled((bool) ($settings[PayseraDeliverySettings::STATUS] ?? 0));

        return $deliverySettings;
    }

    public function mapFromEntity(DeliverySettings $deliverySettings): array
    {
        return [
            PayseraDeliverySettings::STATUS => $deliverySettings->isStatusEnabled() ? 1: 0,
            PayseraDeliverySettings::PROJECT_ID => $deliverySettings->getProjectId() ?? '',
            PayseraDeliverySettings::PROJECT_PASSWORD => $deliverySettings->getProjectPassword() ?? '',
            PayseraDeliverySettings::PROJECT_HASH => $deliverySettings->getProjectHash() ?? '',
            PayseraDeliverySettings::TEST_MODE => $deliverySettings->isTestModeEnabled() ? 1 : 0,
            PayseraDeliverySettings::DELIVERY_GATEWAY => $deliverySettings->getDeliveryGateways() ?? [],
        ];
    }
}
