<?php

declare(strict_types=1);

namespace Paysera\Delivery\Model;

use Paysera\Delivery\Entity\Order;
use Paysera\Delivery\Entity\Product;
use Paysera\Delivery\Exception\ProductNotFoundException;
use Paysera\Delivery\Normalizer\OrderNormalizer;

class OrderModel
{
    /**
     * ModelCheckoutOrder - catalog/model/checkout/order.php
     */
    private $orderModel;

    /**
     * @var ProductModel
     */
    private $productModel;

    /**
     * @var OrderNormalizer
     */
    private $orderNormalizer;

    public function __construct(
        $orderModel,
        ProductModel $productModel,
        OrderNormalizer $orderNormalizer
    ) {
        $this->orderModel = $orderModel;
        $this->productModel = $productModel;
        $this->orderNormalizer = $orderNormalizer;
    }

    public function getOrder(string $orderId): ?Order
    {
        $orderAsArray = $this->orderModel->getOrder($orderId);

        return is_array($orderAsArray) ? $this->orderNormalizer->mapToEntity($orderAsArray) : null;
    }

    /**
     * @param string $orderId
     * @return array<int,Product>
     */
    public function getProductsForOrder(string $orderId): array
    {
        return array_map(
            function (array $orderProduct) {
                $product = $this->productModel->getProduct($orderProduct['product_id']);
                if ($product === null) {
                    throw new ProductNotFoundException();
                }

                $product->setQuantity((int) $orderProduct['quantity']);

                return $product;
            },
            $this->orderModel->getProducts($orderId)
        );
    }
}
