<?php

declare(strict_types=1);

namespace Paysera\Delivery\Exception;

/**
 * Exception thrown when an unsupported OpenCart version is encountered
 */
class UnsupportedVersionException extends CompatibilityException
{
    private string $requestedVersion;
    private array $supportedVersions;

    public function __construct(string $requestedVersion, array $supportedVersions = [], \Throwable $previous = null)
    {
        $this->requestedVersion = $requestedVersion;
        $this->supportedVersions = $supportedVersions;

        $message = sprintf(
            'OpenCart version "%s" is not supported.',
            $requestedVersion
        );

        if (!empty($supportedVersions)) {
            $message .= sprintf(' Supported versions: %s', implode(', ', $supportedVersions));
        }

        parent::__construct($message, 0, $previous);
    }

    public function getRequestedVersion(): string
    {
        return $this->requestedVersion;
    }

    public function getSupportedVersions(): array
    {
        return $this->supportedVersions;
    }
}
