<?php

declare(strict_types=1);

namespace Paysera\Delivery\Exception;

/**
 * Exception thrown when route path resolution fails
 */
class RoutePathResolutionException extends CompatibilityException
{
    private string $originalRoute;

    public function __construct(string $originalRoute, string $message = '', \Throwable $previous = null)
    {
        $this->originalRoute = $originalRoute;

        $finalMessage = $message ?: sprintf('Failed to resolve route path for: %s', $originalRoute);

        parent::__construct($finalMessage, 0, $previous);
    }

    public function getOriginalRoute(): string
    {
        return $this->originalRoute;
    }
}
