<?php

declare(strict_types=1);

namespace Paysera\Delivery\Exception;

/**
 * Exception thrown when no compatible version adapter can be found
 */
class CompatibleVersionNotFoundException extends CompatibilityException
{
    private string $requestedVersion;

    public function __construct(string $requestedVersion, \Throwable $previous = null)
    {
        $this->requestedVersion = $requestedVersion;

        $message = sprintf(
            'No compatible adapter found for OpenCart version "%s"',
            $requestedVersion
        );

        parent::__construct($message, 0, $previous);
    }

    public function getRequestedVersion(): string
    {
        return $this->requestedVersion;
    }
}
