<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class ShipmentRequestGateway
{
    /**
     * @var string
     */
    private $terminal;

    /**
     * @var string
     */
    private $isoCode2;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string|null
     */
    private $zoneCode;

    public function __construct(
        string $terminal,
        string $isoCode2,
        string $city,
        ?string $zoneCode = null
    ) {
        $this->terminal = $terminal;
        $this->isoCode2 = $isoCode2;
        $this->city = $city;
        $this->zoneCode = $zoneCode;
    }

    public function getTerminal(): string
    {
        return $this->terminal;
    }

    public function getIsoCode2(): string
    {
        return $this->isoCode2;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function getZoneCode(): ?string
    {
        return $this->zoneCode;
    }
}
