<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class Order
{
    private string $id;
    private string $paymentFirstName;
    private string $paymentLastName;
    private string $email;
    private string $telephone;
    private string $shippingIsoCode2;
    private string $shippingZoneCode;
    private string $shippingCity;
    private string $shippingAddress1;
    private string $shippingPostcode;
    private string $shippingFirstName;
    private string $shippingLastName;

    public function __construct(
        string $id,
        string $paymentFirstName,
        string $paymentLastName,
        string $email,
        string $telephone,
        string $shippingIsoCode2,
        string $shippingZoneCode,
        string $shippingCity,
        string $shippingAddress1,
        string $shippingPostcode,
        string $shippingFirstName,
        string $shippingLastName
    ) {
        $this->id = $id;
        $this->paymentFirstName = $paymentFirstName;
        $this->paymentLastName = $paymentLastName;
        $this->email = $email;
        $this->telephone = $telephone;
        $this->shippingIsoCode2 = $shippingIsoCode2;
        $this->shippingZoneCode = $shippingZoneCode;
        $this->shippingCity = $shippingCity;
        $this->shippingAddress1 = $shippingAddress1;
        $this->shippingPostcode = $shippingPostcode;
        $this->shippingFirstName = $shippingFirstName;
        $this->shippingLastName = $shippingLastName;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getPaymentFirstName(): string
    {
        return $this->paymentFirstName;
    }

    public function getPaymentLastName(): string
    {
        return $this->paymentLastName;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function getShippingIsoCode2(): string
    {
        return $this->shippingIsoCode2;
    }

    public function getShippingZoneCode(): string
    {
        return $this->shippingZoneCode;
    }

    public function getShippingCity(): string
    {
        return $this->shippingCity;
    }

    public function getShippingAddress1(): string
    {
        return $this->shippingAddress1;
    }

    public function getShippingPostcode(): string
    {
        return $this->shippingPostcode;
    }

    public function getShippingFirstName(): string
    {
        return $this->shippingFirstName;
    }

    public function getShippingLastName(): string
    {
        return $this->shippingLastName;
    }
}
