<?php

declare(strict_types=1);

namespace Paysera\Delivery\Entity;

class Event
{
    private string $code;
    private string $trigger;
    private string $action;
    private string $description;
    private bool $status;
    private int $sortOrder;

    public function __construct(
        string $code,
        string $trigger,
        string $action,
        string $description = '',
        bool $status = true,
        int $sortOrder = 1
    ) {
        $this->code = $code;
        $this->trigger = $trigger;
        $this->action = $action;
        $this->description = $description;
        $this->status = $status;
        $this->sortOrder = $sortOrder;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;
        return $this;
    }

    public function getTrigger(): string
    {
        return $this->trigger;
    }

    public function setTrigger(string $trigger): self
    {
        $this->trigger = $trigger;
        return $this;
    }

    public function getAction(): string
    {
        return $this->action;
    }

    public function setAction(string $action): self
    {
        $this->action = $action;
        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;
        return $this;
    }

    public function isStatus(): bool
    {
        return $this->status;
    }

    public function setStatus(bool $status): self
    {
        $this->status = $status;
        return $this;
    }

    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    public function setSortOrder(int $sortOrder): self
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->code,
            'trigger' => $this->trigger,
            'action' => $this->action,
            'description' => $this->description,
            'status' => $this->status,
            'sort_order' => $this->sortOrder,
        ];
    }

    public static function fromArray(array $data): self
    {
        return new self(
            $data['code'] ?? '',
            $data['trigger'] ?? '',
            $data['action'] ?? '',
            $data['description'] ?? '',
            $data['status'] ?? true,
            $data['sort_order'] ?? 1
        );
    }
}
