<?php

namespace Paysera\Delivery\Entity;

use Paysera\DeliveryApi\MerchantClient\Entity\ShipmentGateway;

class DeliveryGatewaySettings
{
    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $receiverType;

    /**
     * @var string
     */
    private $senderType;

    /**
     * @var float
     */
    private $maximumWeight;

    /**
     * @var float
     */
    private $minimumWeight;

    /**
     * @var float|string
     */
    private $fee;

    /**
     * @var float
     */
    private $freeDeliveryThreshold;

    /**
     * @var ?int
     */
    private $sortOrder;

    /**
     * @var ShipmentGateway
     */
    private $shipmentGateway;

    /**
     * @var ?int
     */
    private $taxClassId;

    /**
     * @var ?int
     */
    private $geoZoneId;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return DeliveryGatewaySettings
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return DeliveryGatewaySettings
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return string
     */
    public function getReceiverType()
    {
        return $this->receiverType;
    }

    /**
     * @param string $receiverType
     * @return DeliveryGatewaySettings
     */
    public function setReceiverType($receiverType)
    {
        $this->receiverType = $receiverType;

        return $this;
    }

    /**
     * @return string
     */
    public function getSenderType()
    {
        return $this->senderType;
    }

    /**
     * @param string $senderType
     * @return DeliveryGatewaySettings
     */
    public function setSenderType($senderType)
    {
        $this->senderType = $senderType;

        return $this;
    }

    /**
     * @return float
     */
    public function getMaximumWeight()
    {
        return $this->maximumWeight;
    }

    /**
     * @param float $maximumWeight
     * @return DeliveryGatewaySettings
     */
    public function setMaximumWeight($maximumWeight)
    {
        $this->maximumWeight = $maximumWeight;

        return $this;
    }

    /**
     * @return float
     */
    public function getMinimumWeight()
    {
        return $this->minimumWeight;
    }

    /**
     * @param float $minimumWeight
     * @return DeliveryGatewaySettings
     */
    public function setMinimumWeight($minimumWeight)
    {
        $this->minimumWeight = $minimumWeight;

        return $this;
    }

    /**
     * @return float|string
     */
    public function getFee()
    {
        return $this->fee;
    }

    /**
     * @param float|string $fee
     * @return DeliveryGatewaySettings
     */
    public function setFee($fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    /**
     * @return float
     */
    public function getFreeDeliveryThreshold()
    {
        return $this->freeDeliveryThreshold;
    }

    /**
     * @param float $freeDeliveryThreshold
     * @return DeliveryGatewaySettings
     */
    public function setFreeDeliveryThreshold($freeDeliveryThreshold)
    {
        $this->freeDeliveryThreshold = $freeDeliveryThreshold;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }

    /**
     * @param ?int $sortOrder
     * @return DeliveryGatewaySettings
     */
    public function setSortOrder($sortOrder = null)
    {
        $this->sortOrder = $sortOrder;

        return $this;
    }

    /**
     * @return ShipmentGateway
     */
    public function getShipmentGateway(): ShipmentGateway
    {
        return $this->shipmentGateway;
    }

    /**
     * @param ?ShipmentGateway $shipmentGateway
     * @return DeliveryGatewaySettings
     */
    public function setShipmentGateway($shipmentGateway = null)
    {
        $this->shipmentGateway = $shipmentGateway;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getGeoZone()
    {
        return $this->geoZoneId;
    }

    /**
     * @param int|null $geoZoneId
     * @return DeliveryGatewaySettings
     */
    public function setGeoZone($geoZoneId = null)
    {
        $this->geoZoneId = $geoZoneId;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getTaxClassId()
    {
        return $this->taxClassId;
    }

    public function setTaxClassId(?int $taxClassId = null): self
    {
        $this->taxClassId = $taxClassId;

        return $this;
    }
}
